# GUIA RÁPIDO DE INSTALAÇÃO - HEROCAT

## ⚡ Instalação em 5 Minutos

### 1️⃣ Requisitos
- XAMPP, WAMP, MAMP ou servidor com PHP 7.4+ e MySQL
- Navegador moderno

### 2️⃣ Passos Rápidos

**A. Copie os arquivos**
```bash
# Coloque a pasta 'herocat' em:
# Windows (XAMPP): C:\xampp\htdocs\
# Mac (MAMP): /Applications/MAMP/htdocs/
# Linux: /var/www/html/
```

**B. Crie o banco de dados**
```bash
1. Abra phpMyAdmin: http://localhost/phpmyadmin
2. Clique em "Novo" ou "New"
3. Nome do banco: herocat_db
4. Collation: utf8mb4_unicode_ci
5. Clique em "SQL" e cole todo o conteúdo do arquivo database_schema.sql
6. Clique em "Executar" ou "Go"
```

**C. Configure o sistema**
```bash
1. Abra: config/database.php
2. Ajuste se necessário:
   DB_HOST: localhost
   DB_USER: root
   DB_PASS: (deixe vazio se for XAMPP)
   DB_NAME: herocat_db
```

**D. Acesse o sistema**
```
http://localhost/herocat
```

## 🎯 Teste Rápido

1. Acesse: http://localhost/herocat/register
2. Crie uma conta
3. Adicione um pet
4. Faça uma caminhada de teste!

## 🆘 Problemas Comuns

### ❌ Erro "Cannot connect to database"
**Solução:**
- Verifique se MySQL está rodando
- Confira as credenciais em config/database.php
- Verifique se o banco foi criado

### ❌ Erro 404 em todas as páginas
**Solução:**
- No XAMPP/WAMP: Habilite mod_rewrite no httpd.conf
- Verifique se o .htaccess existe na pasta raiz
- Ajuste RewriteBase no .htaccess se necessário

### ❌ Upload de imagens não funciona
**Solução:**
```bash
# Crie as pastas manualmente:
herocat/public/uploads/avatars/
herocat/public/uploads/pets/
herocat/logs/

# No Windows, clique com botão direito > Propriedades > Segurança
# Dê permissão total para estas pastas
```

## 📱 Usando a API

### Exemplo JavaScript - Iniciar Caminhada
```javascript
fetch('http://localhost/herocat/api/walks?action=start', {
    method: 'POST',
    headers: {'Content-Type': 'application/json'},
    credentials: 'include',
    body: JSON.stringify({
        pet_id: 1
    })
})
.then(res => res.json())
.then(data => {
    console.log('Caminhada iniciada:', data);
});
```

### Exemplo JavaScript - Rastrear GPS
```javascript
if (navigator.geolocation) {
    navigator.geolocation.getCurrentPosition(position => {
        fetch('http://localhost/herocat/api/walks?action=track', {
            method: 'POST',
            headers: {'Content-Type': 'application/json'},
            credentials: 'include',
            body: JSON.stringify({
                walk_id: 1,
                latitude: position.coords.latitude,
                longitude: position.coords.longitude,
                accuracy: position.coords.accuracy
            })
        })
        .then(res => res.json())
        .then(data => console.log('GPS registrado:', data));
    });
}
```

### Exemplo JavaScript - Finalizar Caminhada
```javascript
fetch('http://localhost/herocat/api/walks?action=finish', {
    method: 'POST',
    headers: {'Content-Type': 'application/json'},
    credentials: 'include',
    body: JSON.stringify({
        walk_id: 1,
        distance: 5.2,      // em km
        duration: 42,       // em minutos
        calories: 250,
        steps: 6500
    })
})
.then(res => res.json())
.then(data => {
    console.log('Caminhada finalizada!');
    console.log('XP ganho:', data.xp_gained);
    console.log('Novo nível do pet:', data.pet.level);
});
```

## 📊 Estrutura do Banco de Dados

### Tabelas Principais
- **users** - Usuários (id, username, email, password, full_name)
- **pets** - Pets (id, user_id, name, type, level, experience)
- **walks** - Caminhadas (id, user_id, pet_id, distance, duration, experience_gained)
- **achievements** - Conquistas disponíveis
- **user_achievements** - Conquistas desbloqueadas

## 🎮 Sistema de Níveis

```
Nível 1: 0 XP
Nível 2: 100 XP
Nível 3: 250 XP
Nível 4: 500 XP
Nível 5: 850 XP
...
Nível 20: 25000 XP
```

**Ganho de XP:**
- 50 XP por quilômetro
- 5 XP por minuto
- 20 XP bônus por completar caminhada
- XP extra das conquistas

## 🏆 Conquistas

1. **Primeiro Passo** - Complete 1 caminhada (50 XP)
2. **Caminhante Iniciante** - 5 km totais (100 XP)
3. **Maratonista** - 50 km totais (500 XP)
4. **Ultra Maratonista** - 100 km totais (1000 XP)
5. **Sequência de 7 dias** - 7 dias consecutivos (200 XP)
6. **Sequência de 30 dias** - 30 dias consecutivos (1000 XP)

## 🔐 Segurança

- ✅ Senhas com hash bcrypt
- ✅ Proteção SQL Injection (PDO)
- ✅ Proteção XSS (sanitização)
- ✅ Sessões seguras
- ✅ Validação de dados

## 📞 Suporte

Se tiver problemas:
1. Verifique os logs em: herocat/logs/error.log
2. Ative DEBUG_MODE em config/config.php
3. Consulte o README.md completo

## ✅ Checklist Pós-Instalação

- [ ] Sistema acessível em http://localhost/herocat
- [ ] Consegue criar conta
- [ ] Consegue fazer login
- [ ] Consegue adicionar pet
- [ ] Consegue iniciar caminhada via API
- [ ] Upload de imagens funcionando
- [ ] Estatísticas sendo calculadas

## 🚀 Próximos Passos

Após instalação:
1. Customize em config/config.php
2. Adicione mais conquistas no banco
3. Personalize o design em public/css/
4. Crie sua própria landing page
5. Integre com aplicativo mobile

---

**Desenvolvido com ❤️ para promover saúde e bem-estar!**

Aproveite o HeroCat! 🐾
