# HeroCat - Sistema de Gamificação de Caminhadas com Pets

Sistema completo de rastreamento e gamificação de caminhadas com pets, desenvolvido em PHP e MySQL.

## 📋 Características

- ✅ Sistema completo de autenticação (login/registro)
- ✅ Gestão de pets (múltiplos pets por usuário)
- ✅ Rastreamento GPS em tempo real
- ✅ Sistema de níveis e XP
- ✅ Conquistas (achievements)
- ✅ Sistema de sequências (streaks)
- ✅ Estatísticas detalhadas
- ✅ Ranking de usuários
- ✅ API RESTful
- ✅ Dashboard responsivo

## 🛠️ Requisitos

- PHP 7.4 ou superior
- MySQL 5.7 ou superior
- Apache/Nginx com mod_rewrite habilitado
- Extensões PHP: PDO, pdo_mysql, json, mbstring

## 📦 Instalação

### 1. Clone ou baixe os arquivos

```bash
# Coloque os arquivos na pasta do seu servidor web
# Exemplo: /var/www/html/herocat ou C:/xampp/htdocs/herocat
```

### 2. Configure o banco de dados

```bash
# Entre no MySQL
mysql -u root -p

# Execute o script SQL
source /caminho/para/database_schema.sql
```

Ou importe manualmente o arquivo `database_schema.sql` via phpMyAdmin.

### 3. Configure o sistema

Edite o arquivo `config/database.php` com suas credenciais:

```php
define('DB_HOST', 'localhost');
define('DB_USER', 'seu_usuario');
define('DB_PASS', 'sua_senha');
define('DB_NAME', 'herocat_db');
```

Edite o arquivo `config/config.php`:

```php
define('SITE_URL', 'http://localhost/herocat'); // Ajuste conforme necessário
```

### 4. Configure permissões

```bash
# Linux/Mac
chmod 755 -R /caminho/para/herocat
chmod 777 -R /caminho/para/herocat/public/uploads
mkdir -p /caminho/para/herocat/logs
chmod 777 /caminho/para/herocat/logs

# Ou via PHP
mkdir('public/uploads/avatars', 0777, true);
mkdir('public/uploads/pets', 0777, true);
mkdir('logs', 0777, true);
```

### 5. Configure .htaccess (Apache)

Crie o arquivo `.htaccess` na raiz:

```apache
<IfModule mod_rewrite.c>
    RewriteEngine On
    RewriteBase /herocat/
    
    # Redireciona tudo para index.php
    RewriteCond %{REQUEST_FILENAME} !-f
    RewriteCond %{REQUEST_FILENAME} !-d
    RewriteRule ^(.*)$ index.php [QSA,L]
</IfModule>
```

### 6. Acesse o sistema

```
http://localhost/herocat
```

## 📁 Estrutura de Diretórios

```
herocat/
├── config/
│   ├── config.php          # Configurações gerais
│   └── database.php        # Configuração do banco
├── controllers/
│   ├── AuthController.php  # Autenticação
│   ├── DashboardController.php  # Dashboard
│   └── WalkAPIController.php    # API de caminhadas
├── models/
│   ├── User.php           # Model de usuário
│   ├── Pet.php            # Model de pet
│   ├── Walk.php           # Model de caminhada
│   └── Achievement.php    # Model de conquistas
├── views/
│   ├── auth/
│   │   ├── login.php
│   │   └── register.php
│   ├── dashboard/
│   │   ├── index.php
│   │   ├── pets.php
│   │   ├── achievements.php
│   │   └── ...
│   ├── home.php
│   └── 404.php
├── public/
│   ├── css/
│   ├── js/
│   ├── images/
│   └── uploads/
│       ├── avatars/
│       └── pets/
├── includes/
│   └── functions.php      # Funções auxiliares
├── logs/
├── database_schema.sql    # Schema do banco de dados
├── index.php             # Front controller
└── README.md
```

## 🔌 API Endpoints

### Autenticação
- `POST /login` - Fazer login
- `POST /register` - Registrar novo usuário
- `GET /logout` - Fazer logout

### Caminhadas
- `POST /api/walks?action=start` - Iniciar caminhada
- `POST /api/walks?action=track` - Adicionar ponto GPS
- `POST /api/walks?action=finish` - Finalizar caminhada
- `GET /api/walks?action=history` - Histórico de caminhadas
- `GET /api/walks?action=details&id=123` - Detalhes de caminhada
- `GET /api/walks?action=stats` - Estatísticas do usuário
- `GET /api/walks?action=monthly&year=2024&month=12` - Stats mensais

### Exemplo de uso da API

```javascript
// Iniciar caminhada
fetch('/api/walks?action=start', {
    method: 'POST',
    headers: {'Content-Type': 'application/json'},
    body: JSON.stringify({
        pet_id: 1
    })
})
.then(res => res.json())
.then(data => console.log(data));

// Adicionar ponto GPS
fetch('/api/walks?action=track', {
    method: 'POST',
    headers: {'Content-Type': 'application/json'},
    body: JSON.stringify({
        walk_id: 1,
        latitude: -23.550520,
        longitude: -46.633308,
        accuracy: 10
    })
})
.then(res => res.json())
.then(data => console.log(data));

// Finalizar caminhada
fetch('/api/walks?action=finish', {
    method: 'POST',
    headers: {'Content-Type': 'application/json'},
    body: JSON.stringify({
        walk_id: 1,
        distance: 5.2,
        duration: 42,
        calories: 250,
        steps: 6500
    })
})
.then(res => res.json())
.then(data => console.log(data));
```

## 🎮 Sistema de Gamificação

### Níveis e XP
- XP por km: 50 pontos
- XP por minuto: 5 pontos
- Bônus diário: 20 pontos
- 20 níveis disponíveis

### Conquistas
- Primeiro Passo
- Caminhante Iniciante (5km)
- Maratonista (50km)
- Ultra Maratonista (100km)
- Sequência de 7 dias
- Sequência de 30 dias
- Níveis 5, 10, 20

### Sequências (Streaks)
Sistema que acompanha dias consecutivos de caminhada.

## 🔒 Segurança

- Senhas hash com bcrypt
- Proteção contra SQL Injection (PDO prepared statements)
- Proteção XSS (sanitização de inputs)
- Proteção CSRF (tokens)
- Sessões seguras
- Validação de dados

## 📊 Banco de Dados

### Principais Tabelas
- `users` - Usuários do sistema
- `pets` - Pets dos usuários
- `walks` - Caminhadas realizadas
- `gps_locations` - Pontos GPS das caminhadas
- `achievements` - Conquistas disponíveis
- `user_achievements` - Conquistas desbloqueadas
- `streaks` - Sequências de dias
- `daily_stats` - Estatísticas diárias
- `level_requirements` - Requisitos de níveis

### Views
- `user_total_stats` - Estatísticas totais por usuário
- `user_ranking` - Ranking de usuários

## 🎨 Personalização

### Alterar sistema de XP
Edite em `config/config.php`:

```php
define('XP_PER_KM', 50);
define('XP_PER_MINUTE', 5);
define('DAILY_WALK_BONUS', 20);
```

### Adicionar conquistas
Insira no banco de dados:

```sql
INSERT INTO achievements (name, description, icon, category, requirement_value, experience_reward)
VALUES ('Nome', 'Descrição', '🏆', 'distance', 100, 500);
```

### Configurar níveis
Edite a tabela `level_requirements` ou o SQL inicial.

## 🐛 Troubleshooting

### Erro de conexão com banco
- Verifique credenciais em `config/database.php`
- Certifique-se que o banco foi criado
- Verifique se o MySQL está rodando

### Erro 404 em todas as páginas
- Verifique se mod_rewrite está habilitado
- Ajuste RewriteBase no .htaccess
- Verifique permissões

### Uploads não funcionam
- Verifique permissões da pasta uploads
- Verifique configurações PHP (upload_max_filesize, post_max_size)

### Sessão não persiste
- Verifique se session_start() está sendo chamado
- Verifique permissões da pasta de sessões do PHP

## 📝 Usuário de Teste

Após instalação, crie um usuário via registro ou insira manualmente:

```sql
INSERT INTO users (username, email, password, full_name)
VALUES ('admin', 'admin@herocat.com', '$2y$12$hash_da_senha', 'Administrador');
```

Senha padrão: `admin123` (use hashPassword('admin123') para gerar o hash)

## 🚀 Próximas Funcionalidades

- [ ] Sistema de amigos
- [ ] Chat entre usuários
- [ ] Desafios semanais
- [ ] Loja de itens
- [ ] Notificações push
- [ ] App mobile (React Native / Flutter)
- [ ] Integração com wearables
- [ ] Mapas interativos avançados

## 📄 Licença

Este projeto é de código aberto e pode ser usado livremente para fins educacionais e comerciais.

## 👨‍💻 Suporte

Para dúvidas ou problemas, consulte a documentação ou entre em contato.

## 🎉 Contribuindo

Contribuições são bem-vindas! Sinta-se livre para abrir issues ou pull requests.

---

Desenvolvido com ❤️ para promover saúde e bem-estar junto com seus pets!
