<?php
/**
 * Configurações Gerais do Sistema
 * HeroCat
 */

// Configurações de sessão
ini_set('session.cookie_httponly', 1);
ini_set('session.use_only_cookies', 1);
ini_set('session.cookie_secure', 0); // Mude para 1 em produção com HTTPS
session_start();

// Timezone
date_default_timezone_set('America/Sao_Paulo');

// Configurações do site
define('SITE_NAME', 'HeroCat');
define('SITE_URL', 'http://localhost/herocat');
define('SITE_EMAIL', 'contato@herocat.com.br');

// Diretórios
define('ROOT_PATH', dirname(__DIR__));
define('PUBLIC_PATH', ROOT_PATH . '/public');
define('UPLOAD_PATH', PUBLIC_PATH . '/uploads');
define('AVATAR_PATH', UPLOAD_PATH . '/avatars');
define('PET_AVATAR_PATH', UPLOAD_PATH . '/pets');

// URLs
define('BASE_URL', SITE_URL);
define('ASSETS_URL', BASE_URL . '/public');

// Configurações de upload
define('MAX_UPLOAD_SIZE', 5 * 1024 * 1024); // 5MB
define('ALLOWED_IMAGE_TYPES', ['image/jpeg', 'image/png', 'image/gif', 'image/webp']);

// Configurações de experiência e níveis
define('XP_PER_KM', 50); // XP ganho por quilômetro
define('XP_PER_MINUTE', 5); // XP ganho por minuto de caminhada
define('DAILY_WALK_BONUS', 20); // Bônus XP por completar uma caminhada

// Configurações de gamificação
define('STREAK_BONUS_XP', 10); // XP bônus por dia de sequência
define('MIN_WALK_DISTANCE', 0.5); // Distância mínima em km para contar como caminhada
define('MIN_WALK_DURATION', 5); // Duração mínima em minutos

// Configurações de segurança
define('PASSWORD_MIN_LENGTH', 8);
define('SESSION_TIMEOUT', 3600 * 24); // 24 horas

// Configurações de paginação
define('ITEMS_PER_PAGE', 20);

// Modo debug (desabilitar em produção)
define('DEBUG_MODE', true);

// Error reporting
if (DEBUG_MODE) {
    error_reporting(E_ALL);
    ini_set('display_errors', 1);
} else {
    error_reporting(0);
    ini_set('display_errors', 0);
}

// Autoloader simples
spl_autoload_register(function ($class) {
    $paths = [
        ROOT_PATH . '/models/',
        ROOT_PATH . '/controllers/',
        ROOT_PATH . '/includes/'
    ];
    
    foreach ($paths as $path) {
        $file = $path . $class . '.php';
        if (file_exists($file)) {
            require_once $file;
            return;
        }
    }
});

// Funções auxiliares
require_once ROOT_PATH . '/includes/functions.php';

// Incluir configuração do banco de dados
require_once ROOT_PATH . '/config/database.php';
