<?php
/**
 * HeroCat - Front Controller
 * Roteamento principal da aplicação
 */

require_once __DIR__ . '/config/config.php';

// Pega a URL requisitada
$request = $_SERVER['REQUEST_URI'];
$request = str_replace('/herocat', '', $request); // Remove base path se necessário
$request = strtok($request, '?'); // Remove query string
$request = rtrim($request, '/');

// Se vazio, usa home
if (empty($request)) {
    $request = '/';
}

// Roteamento
switch ($request) {
    case '/':
    case '/home':
    case '/index':
        require_once __DIR__ . '/views/home.php';
        break;
    
    case '/login':
        $_GET['action'] = 'login';
        require_once __DIR__ . '/controllers/AuthController.php';
        break;
    
    case '/register':
    case '/cadastro':
        $_GET['action'] = 'register';
        require_once __DIR__ . '/controllers/AuthController.php';
        break;
    
    case '/logout':
        $_GET['action'] = 'logout';
        require_once __DIR__ . '/controllers/AuthController.php';
        break;
    
    // Dashboard e páginas internas
    case '/dashboard':
    case (preg_match('/^\/dashboard\//', $request) ? true : false):
        require_once __DIR__ . '/controllers/DashboardController.php';
        break;
    
    // API Endpoints
    case (preg_match('/^\/api\/walks/', $request) ? true : false):
        require_once __DIR__ . '/controllers/WalkAPIController.php';
        break;
    
    case (preg_match('/^\/api\/pets/', $request) ? true : false):
        require_once __DIR__ . '/controllers/PetAPIController.php';
        break;
    
    // Página de jogo/caminhada
    case '/game':
    case '/walk':
        if (!isLoggedIn()) {
            redirect(BASE_URL . '/login');
        }
        require_once __DIR__ . '/views/game.php';
        break;
    
    // 404
    default:
        http_response_code(404);
        require_once __DIR__ . '/views/404.php';
        break;
}
