<?php
/**
 * Script de Instalação do HeroCat
 * Execute este arquivo uma vez para configurar o sistema
 */

error_reporting(E_ALL);
ini_set('display_errors', 1);

$step = $_GET['step'] ?? 1;

?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Instalação - HeroCat</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(165deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 20px;
        }
        .container {
            max-width: 800px;
            margin: 40px auto;
            background: white;
            border-radius: 15px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
            overflow: hidden;
        }
        .header {
            background: linear-gradient(135deg, #6C5CE7, #00B894);
            color: white;
            padding: 30px;
            text-align: center;
        }
        .header h1 {
            font-size: 2.5rem;
            margin-bottom: 10px;
        }
        .content {
            padding: 40px;
        }
        .step-indicator {
            display: flex;
            justify-content: space-between;
            margin-bottom: 40px;
        }
        .step {
            flex: 1;
            text-align: center;
            padding: 10px;
            background: #f0f0f0;
            margin: 0 5px;
            border-radius: 5px;
        }
        .step.active {
            background: #6C5CE7;
            color: white;
        }
        .form-group {
            margin-bottom: 20px;
        }
        label {
            display: block;
            margin-bottom: 5px;
            font-weight: 600;
            color: #2D3436;
        }
        input, select {
            width: 100%;
            padding: 10px;
            border: 2px solid #ddd;
            border-radius: 5px;
            font-size: 1rem;
        }
        input:focus {
            outline: none;
            border-color: #6C5CE7;
        }
        .btn {
            display: inline-block;
            padding: 12px 30px;
            background: linear-gradient(135deg, #6C5CE7, #00B894);
            color: white;
            border: none;
            border-radius: 5px;
            font-size: 1.1rem;
            cursor: pointer;
            text-decoration: none;
        }
        .btn:hover {
            opacity: 0.9;
        }
        .success {
            background: #D5F5E3;
            color: #27AE60;
            padding: 15px;
            border-radius: 5px;
            margin: 20px 0;
        }
        .error {
            background: #FADBD8;
            color: #E74C3C;
            padding: 15px;
            border-radius: 5px;
            margin: 20px 0;
        }
        .info {
            background: #D6EAF8;
            color: #3498DB;
            padding: 15px;
            border-radius: 5px;
            margin: 20px 0;
        }
        pre {
            background: #2D3436;
            color: #00ff00;
            padding: 15px;
            border-radius: 5px;
            overflow-x: auto;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>🐾 HeroCat</h1>
            <p>Assistente de Instalação</p>
        </div>
        
        <div class="content">
            <div class="step-indicator">
                <div class="step <?= $step == 1 ? 'active' : '' ?>">1. Verificação</div>
                <div class="step <?= $step == 2 ? 'active' : '' ?>">2. Banco de Dados</div>
                <div class="step <?= $step == 3 ? 'active' : '' ?>">3. Configuração</div>
                <div class="step <?= $step == 4 ? 'active' : '' ?>">4. Concluído</div>
            </div>

            <?php
            switch($step) {
                case 1:
                    // Verificação de requisitos
                    echo '<h2>Verificação de Requisitos</h2>';
                    
                    $requirements = [
                        'PHP Version >= 7.4' => version_compare(PHP_VERSION, '7.4.0', '>='),
                        'PDO Extension' => extension_loaded('pdo'),
                        'PDO MySQL Extension' => extension_loaded('pdo_mysql'),
                        'JSON Extension' => extension_loaded('json'),
                        'MBString Extension' => extension_loaded('mbstring'),
                    ];
                    
                    $allPassed = true;
                    echo '<ul style="list-style: none; padding: 0;">';
                    foreach($requirements as $req => $passed) {
                        $icon = $passed ? '✅' : '❌';
                        echo "<li style='padding: 10px; margin: 5px 0; background: " . ($passed ? '#D5F5E3' : '#FADBD8') . "; border-radius: 5px;'>$icon $req</li>";
                        if(!$passed) $allPassed = false;
                    }
                    echo '</ul>';
                    
                    if($allPassed) {
                        echo '<div class="success">✅ Todos os requisitos foram atendidos!</div>';
                        echo '<a href="?step=2" class="btn">Próximo: Banco de Dados →</a>';
                    } else {
                        echo '<div class="error">❌ Alguns requisitos não foram atendidos. Por favor, instale as extensões necessárias.</div>';
                    }
                    break;
                    
                case 2:
                    // Configuração do banco de dados
                    echo '<h2>Configuração do Banco de Dados</h2>';
                    
                    if($_SERVER['REQUEST_METHOD'] === 'POST') {
                        $host = $_POST['db_host'];
                        $user = $_POST['db_user'];
                        $pass = $_POST['db_pass'];
                        $name = $_POST['db_name'];
                        
                        try {
                            // Tenta conectar
                            $dsn = "mysql:host=$host";
                            $pdo = new PDO($dsn, $user, $pass);
                            $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
                            
                            // Cria banco se não existir
                            $pdo->exec("CREATE DATABASE IF NOT EXISTS `$name` CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");
                            $pdo->exec("USE `$name`");
                            
                            // Lê e executa SQL
                            $sql = file_get_contents(__DIR__ . '/database_schema.sql');
                            $sql = str_replace('USE herocat_db;', '', $sql);
                            $sql = str_replace('CREATE DATABASE IF NOT EXISTS herocat_db CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;', '', $sql);
                            
                            // Executa queries
                            $pdo->exec($sql);
                            
                            // Salva configurações
                            $configContent = "<?php\ndefine('DB_HOST', '$host');\ndefine('DB_USER', '$user');\ndefine('DB_PASS', '$pass');\ndefine('DB_NAME', '$name');\ndefine('DB_CHARSET', 'utf8mb4');";
                            
                            file_put_contents(__DIR__ . '/config/db_config.php', $configContent);
                            
                            echo '<div class="success">✅ Banco de dados configurado com sucesso!</div>';
                            echo '<a href="?step=3" class="btn">Próximo: Configuração →</a>';
                            
                        } catch(PDOException $e) {
                            echo '<div class="error">❌ Erro: ' . $e->getMessage() . '</div>';
                        }
                    }
                    
                    if(!isset($_POST['db_host'])) {
                        ?>
                        <form method="POST">
                            <div class="form-group">
                                <label>Host do Banco de Dados</label>
                                <input type="text" name="db_host" value="localhost" required>
                            </div>
                            <div class="form-group">
                                <label>Usuário</label>
                                <input type="text" name="db_user" value="root" required>
                            </div>
                            <div class="form-group">
                                <label>Senha</label>
                                <input type="password" name="db_pass">
                            </div>
                            <div class="form-group">
                                <label>Nome do Banco</label>
                                <input type="text" name="db_name" value="herocat_db" required>
                            </div>
                            <button type="submit" class="btn">Instalar Banco de Dados</button>
                        </form>
                        <?php
                    }
                    break;
                    
                case 3:
                    // Configurações finais
                    echo '<h2>Configuração do Sistema</h2>';
                    
                    if($_SERVER['REQUEST_METHOD'] === 'POST') {
                        $siteUrl = rtrim($_POST['site_url'], '/');
                        
                        // Cria diretórios necessários
                        $dirs = [
                            'public/uploads/avatars',
                            'public/uploads/pets',
                            'logs'
                        ];
                        
                        foreach($dirs as $dir) {
                            if(!is_dir($dir)) {
                                mkdir($dir, 0777, true);
                            }
                        }
                        
                        echo '<div class="success">✅ Diretórios criados com sucesso!</div>';
                        echo '<div class="info">URL do site configurada: ' . $siteUrl . '</div>';
                        echo '<a href="?step=4" class="btn">Finalizar Instalação →</a>';
                    } else {
                        $currentUrl = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://" . $_SERVER['HTTP_HOST'];
                        $currentUrl .= dirname($_SERVER['REQUEST_URI']);
                        ?>
                        <form method="POST">
                            <div class="form-group">
                                <label>URL do Site</label>
                                <input type="text" name="site_url" value="<?= $currentUrl ?>" required>
                                <small>A URL base onde o HeroCat está instalado</small>
                            </div>
                            <button type="submit" class="btn">Configurar</button>
                        </form>
                        <?php
                    }
                    break;
                    
                case 4:
                    // Concluído
                    echo '<h2>✅ Instalação Concluída!</h2>';
                    echo '<div class="success">';
                    echo '<h3>Parabéns! O HeroCat foi instalado com sucesso.</h3>';
                    echo '<p><strong>Próximos passos:</strong></p>';
                    echo '<ol>';
                    echo '<li>Delete ou renomeie o arquivo <code>install.php</code> por segurança</li>';
                    echo '<li>Acesse <a href="register.php">página de registro</a> para criar sua conta</li>';
                    echo '<li>Faça login e comece a usar o sistema!</li>';
                    echo '</ol>';
                    echo '</div>';
                    
                    echo '<div class="info">';
                    echo '<h4>Credenciais de teste (opcional):</h4>';
                    echo '<p>Usuário: <strong>admin</strong><br>';
                    echo 'Senha: <strong>admin123</strong></p>';
                    echo '</div>';
                    
                    echo '<a href="index.php" class="btn">Ir para o Site →</a>';
                    break;
            }
            ?>
        </div>
    </div>
</body>
</html>
