<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - HeroCat</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600;700&display=swap" rel="stylesheet">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Poppins', sans-serif;
            background: linear-gradient(165deg, #667eea 0%, #764ba2 40%, #f093fb 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }

        .login-container {
            background: white;
            border-radius: 20px;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
            overflow: hidden;
            max-width: 400px;
            width: 100%;
            animation: slideUp 0.5s ease-out;
        }

        @keyframes slideUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .login-header {
            background: linear-gradient(135deg, #6C5CE7, #00B894);
            padding: 40px;
            text-align: center;
            color: white;
        }

        .login-header h1 {
            font-size: 2rem;
            margin-bottom: 10px;
        }

        .login-header p {
            opacity: 0.9;
        }

        .login-form {
            padding: 40px;
        }

        .form-group {
            margin-bottom: 25px;
        }

        .form-group label {
            display: block;
            margin-bottom: 8px;
            color: #2D3436;
            font-weight: 600;
        }

        .form-group input {
            width: 100%;
            padding: 12px 15px;
            border: 2px solid #DFE6E9;
            border-radius: 10px;
            font-size: 1rem;
            transition: all 0.3s;
            font-family: 'Poppins', sans-serif;
        }

        .form-group input:focus {
            outline: none;
            border-color: #6C5CE7;
        }

        .btn-login {
            width: 100%;
            padding: 15px;
            background: linear-gradient(135deg, #6C5CE7, #00B894);
            color: white;
            border: none;
            border-radius: 10px;
            font-size: 1.1rem;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s;
        }

        .btn-login:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 20px rgba(108, 92, 231, 0.3);
        }

        .register-link {
            text-align: center;
            margin-top: 20px;
            color: #636E72;
        }

        .register-link a {
            color: #6C5CE7;
            text-decoration: none;
            font-weight: 600;
        }

        .register-link a:hover {
            text-decoration: underline;
        }

        .flash-message {
            padding: 15px;
            margin-bottom: 20px;
            border-radius: 10px;
            font-weight: 500;
        }

        .flash-success {
            background: #D5F5E3;
            color: #27AE60;
            border: 1px solid #27AE60;
        }

        .flash-error {
            background: #FADBD8;
            color: #E74C3C;
            border: 1px solid #E74C3C;
        }

        .flash-info {
            background: #D6EAF8;
            color: #3498DB;
            border: 1px solid #3498DB;
        }

        .errors-list {
            background: #FADBD8;
            border: 1px solid #E74C3C;
            color: #E74C3C;
            padding: 15px;
            border-radius: 10px;
            margin-bottom: 20px;
        }

        .errors-list ul {
            margin-left: 20px;
        }

        .back-home {
            text-align: center;
            margin-top: 15px;
        }

        .back-home a {
            color: #636E72;
            text-decoration: none;
            font-size: 0.9rem;
        }

        .back-home a:hover {
            color: #6C5CE7;
        }
    </style>
</head>
<body>
    <div class="login-container">
        <div class="login-header">
            <h1>🐾 HeroCat</h1>
            <p>Entre na sua conta</p>
        </div>

        <div class="login-form">
            <?php
            // Exibe mensagem flash
            $flash = getFlashMessage();
            if ($flash):
            ?>
                <div class="flash-message flash-<?= $flash['type'] ?>">
                    <?= htmlspecialchars($flash['message']) ?>
                </div>
            <?php endif; ?>

            <?php
            // Exibe erros
            if (isset($_SESSION['errors']) && !empty($_SESSION['errors'])):
            ?>
                <div class="errors-list">
                    <ul>
                        <?php foreach ($_SESSION['errors'] as $error): ?>
                            <li><?= htmlspecialchars($error) ?></li>
                        <?php endforeach; ?>
                    </ul>
                </div>
                <?php unset($_SESSION['errors']); ?>
            <?php endif; ?>

            <form method="POST" action="<?= BASE_URL ?>/login">
                <div class="form-group">
                    <label for="email_username">Email ou Usuário</label>
                    <input type="text" id="email_username" name="email_username" required autofocus>
                </div>

                <div class="form-group">
                    <label for="password">Senha</label>
                    <input type="password" id="password" name="password" required>
                </div>

                <button type="submit" class="btn-login">Entrar</button>
            </form>

            <div class="register-link">
                Não tem uma conta? <a href="<?= BASE_URL ?>/register">Cadastre-se</a>
            </div>

            <div class="back-home">
                <a href="<?= BASE_URL ?>">← Voltar para home</a>
            </div>
        </div>
    </div>
</body>
</html>
