<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cadastro - HeroCat</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600;700&display=swap" rel="stylesheet">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Poppins', sans-serif;
            background: linear-gradient(165deg, #667eea 0%, #764ba2 40%, #f093fb 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }

        .register-container {
            background: white;
            border-radius: 20px;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
            overflow: hidden;
            max-width: 500px;
            width: 100%;
            animation: slideUp 0.5s ease-out;
        }

        @keyframes slideUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .register-header {
            background: linear-gradient(135deg, #6C5CE7, #00B894);
            padding: 40px;
            text-align: center;
            color: white;
        }

        .register-header h1 {
            font-size: 2rem;
            margin-bottom: 10px;
        }

        .register-header p {
            opacity: 0.9;
        }

        .register-form {
            padding: 40px;
        }

        .form-group {
            margin-bottom: 20px;
        }

        .form-group label {
            display: block;
            margin-bottom: 8px;
            color: #2D3436;
            font-weight: 600;
            font-size: 0.9rem;
        }

        .form-group input {
            width: 100%;
            padding: 12px 15px;
            border: 2px solid #DFE6E9;
            border-radius: 10px;
            font-size: 1rem;
            transition: all 0.3s;
            font-family: 'Poppins', sans-serif;
        }

        .form-group input:focus {
            outline: none;
            border-color: #6C5CE7;
        }

        .btn-register {
            width: 100%;
            padding: 15px;
            background: linear-gradient(135deg, #6C5CE7, #00B894);
            color: white;
            border: none;
            border-radius: 10px;
            font-size: 1.1rem;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s;
            margin-top: 10px;
        }

        .btn-register:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 20px rgba(108, 92, 231, 0.3);
        }

        .login-link {
            text-align: center;
            margin-top: 20px;
            color: #636E72;
        }

        .login-link a {
            color: #6C5CE7;
            text-decoration: none;
            font-weight: 600;
        }

        .login-link a:hover {
            text-decoration: underline;
        }

        .errors-list {
            background: #FADBD8;
            border: 1px solid #E74C3C;
            color: #E74C3C;
            padding: 15px;
            border-radius: 10px;
            margin-bottom: 20px;
        }

        .errors-list ul {
            margin-left: 20px;
        }

        .back-home {
            text-align: center;
            margin-top: 15px;
        }

        .back-home a {
            color: #636E72;
            text-decoration: none;
            font-size: 0.9rem;
        }

        .back-home a:hover {
            color: #6C5CE7;
        }

        .password-strength {
            margin-top: 5px;
            font-size: 0.85rem;
            color: #636E72;
        }
    </style>
</head>
<body>
    <div class="register-container">
        <div class="register-header">
            <h1>🐾 HeroCat</h1>
            <p>Crie sua conta gratuita</p>
        </div>

        <div class="register-form">
            <?php
            // Exibe erros
            if (isset($_SESSION['errors']) && !empty($_SESSION['errors'])):
            ?>
                <div class="errors-list">
                    <ul>
                        <?php foreach ($_SESSION['errors'] as $error): ?>
                            <li><?= htmlspecialchars($error) ?></li>
                        <?php endforeach; ?>
                    </ul>
                </div>
                <?php unset($_SESSION['errors']); ?>
            <?php endif; ?>

            <?php
            $oldInput = $_SESSION['old_input'] ?? [];
            unset($_SESSION['old_input']);
            ?>

            <form method="POST" action="<?= BASE_URL ?>/register">
                <div class="form-group">
                    <label for="full_name">Nome Completo</label>
                    <input type="text" id="full_name" name="full_name" 
                           value="<?= htmlspecialchars($oldInput['full_name'] ?? '') ?>" 
                           required autofocus>
                </div>

                <div class="form-group">
                    <label for="username">Usuário</label>
                    <input type="text" id="username" name="username" 
                           value="<?= htmlspecialchars($oldInput['username'] ?? '') ?>" 
                           required pattern="[a-zA-Z0-9_]+" 
                           title="Apenas letras, números e underscore">
                </div>

                <div class="form-group">
                    <label for="email">Email</label>
                    <input type="email" id="email" name="email" 
                           value="<?= htmlspecialchars($oldInput['email'] ?? '') ?>" 
                           required>
                </div>

                <div class="form-group">
                    <label for="password">Senha</label>
                    <input type="password" id="password" name="password" 
                           required minlength="8">
                    <div class="password-strength">Mínimo 8 caracteres</div>
                </div>

                <div class="form-group">
                    <label for="password_confirm">Confirmar Senha</label>
                    <input type="password" id="password_confirm" name="password_confirm" required>
                </div>

                <button type="submit" class="btn-register">Criar Conta</button>
            </form>

            <div class="login-link">
                Já tem uma conta? <a href="<?= BASE_URL ?>/login">Faça login</a>
            </div>

            <div class="back-home">
                <a href="<?= BASE_URL ?>">← Voltar para home</a>
            </div>
        </div>
    </div>

    <script>
        // Validação de senha em tempo real
        document.getElementById('password_confirm').addEventListener('input', function() {
            const password = document.getElementById('password').value;
            const confirm = this.value;
            
            if (confirm && password !== confirm) {
                this.setCustomValidity('As senhas não coincidem');
            } else {
                this.setCustomValidity('');
            }
        });
    </script>
</body>
</html>
