<?php
// Redireciona para dashboard se já estiver logado
if (isLoggedIn()) {
    redirect(BASE_URL . '/dashboard');
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>HeroCat - Evolua com Cada Passo</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600;700;900&family=Space+Mono:wght@400;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="<?= ASSETS_URL ?>/css/home.css">
</head>
<body>
    <!-- Conteúdo da landing page aqui -->
    <div class="geometric-bg">
        <div class="geo-shape geo1"></div>
        <div class="geo-shape geo2"></div>
        <div class="geo-shape geo3"></div>
    </div>

    <div class="container">
        <header>
            <div class="logo">HEROCAT</div>
        </header>

        <div class="hero">
            <h1 class="hero-title">Evolua com Cada Passo</h1>
            <p class="hero-subtitle">Rastreamento inteligente. Gamificação poderosa. Saúde real.</p>
            <p class="hero-tagline">Você + Seu Pet = Imparável</p>
        </div>

        <div class="cta-section">
            <a href="<?= BASE_URL ?>/register" class="cta-button">COMEÇAR AGORA</a>
            <div style="margin-top: 20px;">
                <a href="<?= BASE_URL ?>/login" style="color: white; text-decoration: none; font-size: 1.1rem;">Já tem conta? Faça login</a>
            </div>
        </div>

        <footer style="margin-top: 100px; text-align: center; color: white; padding: 40px;">
            <p>© 2024 HeroCat - Transforme Passeios em Evolução</p>
            <p style="margin-top: 10px;">www.herocat.com.br</p>
        </footer>
    </div>
</body>
</html>
